#version 330
#extension GL_EXT_gpu_shader4 : enable
//Flower PatternsMod01.fsh  by  nr4

//https://www.shadertoy.com/view/lt3yRX
// Licence CC0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.177
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D iChannel0;
uniform sampler2D iChannel1;
uniform sampler2D iChannel2;
uniform sampler2D iChannel3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

/*
 * Flower Pattern
 * 
 * Copyright (C) 2018  Alexander Kraus <nr4@z10.info>
 * 
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

const float pi = acos(-1.);
const vec3 c = vec3(1.,0.,-1.);

// compute distance to regular star
float dstar(vec2 x, float N, vec2 R)
{
    float d = pi/N,
        p0 = acos(x.x/length(x)),
        p = mod(p0, d),
        i = mod(round((p-p0)/d),2.);
    x = length(x)*vec2(cos(p),sin(p));
    vec2 a = mix(R,R.yx,i),
    	p1 = a.x*c.xy,
        ff = a.y*vec2(cos(d),sin(d))-p1;
   	ff = ff.yx*c.zx;
    return dot(x-p1,ff)/length(ff);
}

#define A iResolution.y
#define S(v) smoothstep(-1.5/A,1.5/A,v)
void main (void)
//void mainImage( out vec4 fragColor, in vec2 fragCoord )
{
    float N = 5., d = 2.*pi/N*sin(.1*iTime);
    vec2 uv = gl_FragCoord.xy/A-vec2(.5*iResolution.x/A,.5), 
        k = vec2(cos(d),sin(d)),
        t = c.zx, e;
    mat2 R = mat2(k.x,k.y,-k.y,k.x);
    
    for(float i = 2.; i > .05; i = i*(.85+.1*sin(.3*iTime)))
    {
        uv = R*uv;
        e = vec2(dstar(uv, N, i*vec2(1.+.5*cos(3.4221*iTime),1.+.5*sin(2.153*iTime))),i);
        t = mix(t,e,step(-3./A,e.x));
    }
    e = vec2(.025-length(uv),pi); 
    
    //set random colors
    vec3 col = .8 + .5*cos(1.+uv.xyx+t.y*1.5e1+iTime+vec3(0.,2.,4.));
    gl_FragColor = vec4(col*mix(S(t.x),1.,.5)+S(-abs(t.x))+col.zxy*S(e.x)+S(-abs(e.x)),1.);
}
